

<?php $__env->startSection('title', 'Editar Cliente'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 700px;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Editar Cliente</h5>
            <a href="<?php echo e(route('clientes.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('clientes.update', $cliente)); ?>" method="POST" class="mt-3">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label for="nombre" class="form-label">Nombre del cliente</label>
                <input type="text" name="nombre" id="nombre" class="form-control" value="<?php echo e(old('nombre', $cliente->nombre)); ?>" required>
            </div>

            <div class="mb-3">
                <label for="telefono" class="form-label">Teléfono</label>
                <input type="text" name="telefono" id="telefono" class="form-control" value="<?php echo e(old('telefono', $cliente->telefono)); ?>">
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">Correo electrónico</label>
                <input type="email" name="email" id="email" class="form-control" value="<?php echo e(old('email', $cliente->email)); ?>">
            </div>

            <div class="mb-3">
                <label for="direccion" class="form-label">Dirección</label>
                <textarea name="direccion" id="direccion" class="form-control"><?php echo e(old('direccion', $cliente->direccion)); ?></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Actualizar Cliente</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/clientes/edit.blade.php ENDPATH**/ ?>