

<?php $__env->startSection('title', 'Asistencias Registradas'); ?>

<?php $__env->startSection('content'); ?>
<div class="container" style="max-width: 1000px;">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 text-center text-md-start">
        <h2 class="mb-3 mb-md-0">Asistencias</h2>
        
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php elseif(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <!-- ✅ Contenedor responsive para móviles -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle text-center">
            <thead class="table-light">
                <tr>
                    <th>Empleado</th>
                    <th>C.I.</th>
                    <th>Fecha</th>
                    <th>Entrada</th>
                    <th>Salida</th>
                    <th>Estado</th>
                    <th>Ubicación</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $asistencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asistencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php echo e($asistencia->empleado->user->nombres ?? 'Sin nombre'); ?>

                        <?php echo e($asistencia->empleado->user->apellido_paterno ?? ''); ?>

                    </td>
                    <td><?php echo e($asistencia->empleado->ci); ?></td>
                    <td><?php echo e($asistencia->fecha); ?></td>
                    <td><?php echo e($asistencia->hora_entrada ?? '-'); ?></td>
                    <td><?php echo e($asistencia->hora_salida ?? '-'); ?></td>
                    <td>
                        <?php
                        $badgeClass = match($asistencia->estado) {
                        'PRESENTE' => 'success',
                        'RETRASO' => 'warning',
                        'AUSENTE' => 'danger',
                        'SALIDA_ANTICIPADA' => 'secondary',
                        default => 'dark'
                        };
                        ?>
                        <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e($asistencia->estado); ?></span>
                    </td>
                    <td>
                        <?php if($asistencia->ubicacion_marcaje): ?>
                        <a href="<?php echo e($asistencia->ubicacion_marcaje); ?>" target="_blank"
                            class="btn btn-sm btn-outline-primary">Ver mapa</a>
                        <?php else: ?>
                        <span class="text-muted">No registrada</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">No hay asistencias registradas.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/asistencias/index.blade.php ENDPATH**/ ?>