

<?php $__env->startSection('title', 'Reporte de Ventas'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h4 class="mb-4">Reporte de Ventas</h4>

    <form method="GET" action="<?php echo e(route('reportes.ventas.index')); ?>" class="row g-3 mb-4">
        <div class="col-md-3">
            <label for="desde" class="form-label">Desde</label>
            <input type="date" name="desde" id="desde" value="<?php echo e(request('desde')); ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label for="hasta" class="form-label">Hasta</label>
            <input type="date" name="hasta" id="hasta" value="<?php echo e(request('hasta')); ?>" class="form-control">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Filtrar</button>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <a href="<?php echo e(route('reportes.ventas.index')); ?>" class="btn btn-outline-secondary w-100">Restablecer</a>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <a href="<?php echo e(route('reportes.ventas.pdf', ['desde' => request('desde'), 'hasta' => request('hasta')])); ?>"
                class="btn btn-danger w-100" target="_blank">
                <i class="fas fa-file-pdf"></i> Generar PDF
            </a>
        </div>
    </form>



    <div class="table-responsive bg-white shadow-sm rounded p-3">
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-light text-center">
                <tr>
                    <th>Nro Venta</th>
                    <th>Cliente</th>
                    <th>Fecha</th>
                    <th>Tipo</th>
                    <th>Producto</th>
                    <th>Cantidad</th>
                    <th>Precio Unitario</th>
                    <th>Subtotal</th>
                    <th>Recibo</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php $detalleCount = $venta->detalles->count(); ?>

                <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-center">
                    <?php if($index === 0): ?>
                    <td rowspan="<?php echo e($detalleCount); ?>"><?php echo e($venta->id); ?></td>
                    <td rowspan="<?php echo e($detalleCount); ?>"><?php echo e($venta->cliente->nombre ?? 'Sin cliente'); ?></td>
                    <td rowspan="<?php echo e($detalleCount); ?>"><?php echo e(\Carbon\Carbon::parse($venta->fecha_venta)->format('d/m/Y')); ?></td>
                    <td rowspan="<?php echo e($detalleCount); ?>">
                        <span class="badge <?php echo e($detalle->tipo_precio == 'contado' ? 'bg-success' : 'bg-warning text-dark'); ?>">
                            <?php echo e(ucfirst($detalle->tipo_precio)); ?>

                        </span>
                    </td>
                    <?php endif; ?>

                    <td><?php echo e($detalle->nombre_producto ?? ($detalle->producto->nombre ?? 'Producto')); ?></td>
                    <td><?php echo e($detalle->cantidad); ?></td>
                    <td>Bs. <?php echo e(number_format($detalle->precio_unitario, 2)); ?></td>
                    <td>Bs. <?php echo e(number_format($detalle->precio_unitario * $detalle->cantidad, 2)); ?></td>

                    <?php if($index === 0): ?>
                    <td rowspan="<?php echo e($detalleCount); ?>">
                        <a href="<?php echo e(route('ventas.recibo', $venta->id)); ?>" class="btn btn-sm btn-outline-dark" target="_blank">
                            <i class="fas fa-file-pdf"></i> PDF
                        </a>
                    </td>
                    <?php endif; ?>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="9" class="text-center text-muted">No hay ventas registradas.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ferr_limpio\resources\views/reportes/ventas/index.blade.php ENDPATH**/ ?>