

<?php $__env->startSection('title', 'Usuarios'); ?>

<?php $__env->startSection('content'); ?>

<?php
$rol = auth()->user()->rol ?? null;
?>

<?php if($rol !== 'administrador'): ?>
<div class="container mt-5 text-center">
    <h3 class="text-danger">🚫 Acceso denegado</h3>
    <p>No tienes permiso para ver este módulo.</p>
    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-primary mt-3">Volver al inicio</a>
</div>
<?php else: ?>
<div class="container d-flex justify-content-between align-items-center mb-4" style="max-width: 900px;">
    <h4 class="mb-0">Lista de usuarios</h4>
    <a href="<?php echo e(route('usuarios.create')); ?>" class="btn btn-primary">+ Nuevo Usuario</a>
</div>

<?php if(session('success')): ?>
<div class="container" style="max-width: 900px;">
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
</div>
<?php endif; ?>

<div class="container" style="max-width: 900px;">
    <div class="table-responsive rounded shadow-sm bg-white">
        <table class="table table-bordered table-hover align-middle mb-0">
            <thead class="table-light">
                <tr class="text-center">
                    <th style="width: 60px;">Nro.</th>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th style="width: 150px;">Rol</th>
                    <th style="width: 180px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="text-center">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td class="text-start"><?php echo e($usuario->nombre); ?></td>
                    <td class="text-start"><?php echo e($usuario->email); ?></td>
                    <td>
                        <span class="badge bg-secondary text-capitalize">
                            <?php echo e($usuario->rol); ?>

                        </span>
                    </td>
                    <td>
                        <a href="<?php echo e(route('usuarios.edit', $usuario)); ?>" class="btn btn-warning btn-sm me-1">
                            Editar
                        </a>
                        <form action="<?php echo e(route('usuarios.destroy', $usuario)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Deseas eliminar este usuario?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">Eliminar</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No hay usuarios registrados.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/usuarios/index.blade.php ENDPATH**/ ?>