

<?php $__env->startSection('title', 'Editar Empleado'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3 class="mb-4">Editar Empleado</h3>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <form action="<?php echo e(route('empleados.update', $empleado)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <div class="mb-3">
            <label class="form-label">Usuario del Sistema</label>
            <input type="text" class="form-control" value="<?php echo e($empleado->user->nombres ?? 'Sin nombre'); ?> <?php echo e($empleado->user->apellido_paterno ?? ''); ?>" disabled>
            <input type="hidden" name="user_id" value="<?php echo e($empleado->user_id); ?>">
        </div>

        
        <div class="mb-3">
            <label class="form-label">Foto Actual</label><br>
            <?php if($empleado->foto): ?>
            <img src="<?php echo e(asset('storage/' . $empleado->foto)); ?>" alt="Foto" width="80" class="rounded mb-2">
            <?php else: ?>
            <p class="text-muted">Sin foto</p>
            <?php endif; ?>
            <input type="file" name="foto" class="form-control" accept="image/*">
            <small class="text-muted">Dejar en blanco si no deseas cambiar la foto.</small>
        </div>

        
        <div class="mb-3">
            <label for="edad" class="form-label">Edad</label>
            <input type="number" name="edad" id="edad" class="form-control" value="<?php echo e(old('edad', $empleado->edad)); ?>" required>
        </div>

        
        <div class="mb-3">
            <label for="ci" class="form-label">Cédula de Identidad</label>
            <input type="text" name="ci" id="ci" class="form-control" value="<?php echo e(old('ci', $empleado->ci)); ?>" required>
        </div>

        
        <div class="mb-3">
            <label for="celular" class="form-label">Celular</label>
            <input type="text" name="celular" id="celular" class="form-control" value="<?php echo e(old('celular', $empleado->celular)); ?>" required>
        </div>

        
        <div class="mb-3">
            <label for="fecha_ingreso" class="form-label">Fecha de Ingreso</label>
            <input type="date" name="fecha_ingreso" id="fecha_ingreso" class="form-control" value="<?php echo e(old('fecha_ingreso', $empleado->fecha_ingreso)); ?>" required>
        </div>

        <div class="mb-3">
            <label for="fecha_retiro" class="form-label">Fecha de Retiro (opcional)</label>
            <input type="date" name="fecha_retiro" id="fecha_retiro" class="form-control" value="<?php echo e(old('fecha_retiro', $empleado->fecha_retiro)); ?>">
        </div>

        
        <div class="mb-3">
            <label for="referencia_1_nombre" class="form-label">Nombre Referencia Familiar 1</label>
            <input type="text" name="referencia_1_nombre" id="referencia_1_nombre" class="form-control" value="<?php echo e(old('referencia_1_nombre', $empleado->referencia_1_nombre)); ?>" required>
        </div>

        <div class="mb-3">
            <label for="referencia_1_celular" class="form-label">Celular Referencia 1</label>
            <input type="text" name="referencia_1_celular" id="referencia_1_celular" class="form-control" value="<?php echo e(old('referencia_1_celular', $empleado->referencia_1_celular)); ?>" required>
        </div>

        
        <div class="mb-3">
            <label for="referencia_2_nombre" class="form-label">Nombre Referencia Familiar 2</label>
            <input type="text" name="referencia_2_nombre" id="referencia_2_nombre" class="form-control" value="<?php echo e(old('referencia_2_nombre', $empleado->referencia_2_nombre)); ?>">
        </div>

        <div class="mb-3">
            <label for="referencia_2_celular" class="form-label">Celular Referencia 2</label>
            <input type="text" name="referencia_2_celular" id="referencia_2_celular" class="form-control" value="<?php echo e(old('referencia_2_celular', $empleado->referencia_2_celular)); ?>">
        </div>

        
        <div class="mb-3">
            <label for="ubicacion_domicilio" class="form-label">Ubicación de Domicilio</label>
            <textarea name="ubicacion_domicilio" id="ubicacion_domicilio" class="form-control" rows="2"><?php echo e(old('ubicacion_domicilio', $empleado->ubicacion_domicilio)); ?></textarea>
        </div>

        <div class="text-end">
            <button type="submit" class="btn btn-primary">Actualizar Empleado</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/empleados/edit.blade.php ENDPATH**/ ?>