

<?php $__env->startSection('title', 'Ventas'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-between align-items-center mb-4" style="max-width: 1000px;">
    <h4 class="mb-0">Lista de Ventas</h4>
    <a href="<?php echo e(route('ventas.create')); ?>" class="btn btn-primary">+ Nueva Venta</a>
    <form method="GET" action="<?php echo e(route('ventas.index')); ?>" class="d-flex align-items-end gap-2 mb-3" style="max-width: 1000px;">
        <div>
            <label for="fecha" class="form-label mb-0">Filtrar por Fecha</label>
            <input type="date" name="fecha" id="fecha" value="<?php echo e($fecha); ?>" class="form-control">
        </div>
        <div>
            <button type="submit" class="btn btn-outline-primary mt-1">Filtrar</button>
        </div>
    </form>

</div>

<?php if(session('success')): ?>
<div class="container" style="max-width: 1000px;">
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
</div>
<?php endif; ?>

<div class="container" style="max-width: 1000px;">
    <div class="table-responsive rounded shadow-sm bg-white">
        <table class="table table-bordered table-hover align-middle mb-0">
            <thead class="table-light text-center">
                <tr>
                    <th>Nro.</th>
                    <th>Cliente</th>
                    <th>Fecha</th>
                    <th>Tipo de Pago</th>
                    <th>Tipo de documento</th>
                    <th>Observaciones</th>
                    <th>Total</th>
                    <th>Estado Entrega</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-center">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($venta->cliente ? $venta->cliente->nombre : 'Venta directa'); ?></td>
                    <td><?php echo e($venta->fecha_venta); ?></td>
                    <td><?php echo e(ucfirst($venta->tipo_pago)); ?></td>
                    <td><?php echo e(ucfirst($venta->tipo_documento)); ?></td>
                    <td><?php echo e($venta->observaciones ?? '-'); ?></td>
                    <td>Bs. <?php echo e(number_format($venta->total, 2, ',', '.')); ?></td>
                    <td>
                        <span class="badge
                            <?php echo e($venta->estado_entrega === 'entregado' ? 'bg-success' :
                                ($venta->estado_entrega === 'parcial' ? 'bg-warning text-dark' : 'bg-secondary')); ?>">
                            <?php echo e(ucfirst($venta->estado_entrega)); ?>

                        </span>
                    </td>
                    <td>
                        <div class="d-flex justify-content-center gap-1 flex-wrap">
                            <a href="<?php echo e(route('ventas.show', $venta)); ?>" class="btn btn-sm btn-info">Ver</a>
                            <a href="<?php echo e(route('ventas.edit', $venta)); ?>" class="btn btn-sm btn-warning">Editar</a>
                            <form action="<?php echo e(route('ventas.destroy', $venta)); ?>" method="POST" onsubmit="return confirm('¿Deseas eliminar esta venta?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-danger">Eliminar</button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($ventas->isEmpty()): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">No hay ventas registradas.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/imagendig85b/public_html/isactamayo.imagendigitalb.com/resources/views/ventas/index.blade.php ENDPATH**/ ?>