

<?php $__env->startSection('title', 'Categorías'); ?>

<?php $__env->startSection('content'); ?>
<div class="container" style="max-width: 900px;">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">Lista de Categorías</h4>
        <a href="<?php echo e(route('categorias.create')); ?>" class="btn btn-primary">+ Nueva Categoría</a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div class="table-responsive bg-white rounded shadow-sm">
        <table class="table table-bordered table-hover align-middle mb-0">
            <thead class="table-light">
                <tr class="text-center">
                    <th style="width: 60px;">Nro.</th>
                    <th>Nombre</th>
                    <th>Descripción</th>
                    <th style="width: 180px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="text-center align-middle">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td class="text-start">
                        <a href="#collapseCategoria<?php echo e($categoria->id); ?>" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapseCategoria<?php echo e($categoria->id); ?>">
                            <?php echo e($categoria->nombre); ?>

                        </a>
                    </td>
                    <td class="text-start"><?php echo e($categoria->descripcion); ?></td>
                    <td>
                        <a href="<?php echo e(route('categorias.edit', $categoria)); ?>" class="btn btn-warning btn-sm me-1">Editar</a>
                        <form action="<?php echo e(route('categorias.destroy', $categoria)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar esta categoría?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">Eliminar</button>
                        </form>
                    </td>
                </tr>

                <!-- Subfila con productos -->
                <tr class="collapse bg-light" id="collapseCategoria<?php echo e($categoria->id); ?>">
                    <td colspan="4">
                        <strong>Productos en esta categoría:</strong>
                        <?php if($categoria->productos->isEmpty()): ?>
                        <div class="text-muted mt-2">No hay productos registrados en esta categoría.</div>
                        <?php else: ?>
                        <div class="table-responsive mt-2">
                            <table class="table table-sm table-bordered align-middle mb-0">
                                <thead class="table-secondary text-center">
                                    <tr>
                                        <th>#</th>
                                        <th>Nombre</th>
                                        <th>Marca</th>
                                        <th>Unidad</th>
                                        <th>Precio</th>
                                        <th>Stock Disponible</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $categoria->productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="text-center">
                                        <td><?php echo e($i + 1); ?></td>
                                        <td class="text-start"><?php echo e($producto->nombre); ?></td>
                                        <td><?php echo e($producto->marca ?? '-'); ?></td>
                                        <td><?php echo e($producto->unidad ?? '-'); ?></td>
                                        <td>Bs. <?php echo e(number_format($producto->precio, 2, ',', '.')); ?></td>
                                        <td><?php echo e($producto->stock_disponible); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="text-center text-muted">No hay categorías registradas.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/categorias/index.blade.php ENDPATH**/ ?>