

<?php $__env->startSection('title', 'Clientes'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-between align-items-center mb-4" style="max-width: 900px;">
    <h4 class="mb-0">Lista de Clientes</h4>
    <a href="<?php echo e(route('clientes.create')); ?>" class="btn btn-primary">+ Nuevo Cliente</a>
</div>

<?php if(session('success')): ?>
<div class="container" style="max-width: 900px;">
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
</div>
<?php endif; ?>

<div class="container" style="max-width: 900px;">
    <div class="table-responsive rounded shadow-sm bg-white">
        <table class="table table-bordered table-hover align-middle mb-0">
            <thead class="table-light">
                <tr class="text-center">
                    <th style="width: 60px;">Nro.</th>
                    <th>Nombre</th>
                    <th>Teléfono</th>
                    <th>Email</th>
                    <th>Dirección</th>
                    <th style="width: 160px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="text-center">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td class="text-start"><?php echo e($cliente->nombre); ?></td>
                    <td><?php echo e($cliente->telefono); ?></td>
                    <td><?php echo e($cliente->email); ?></td>
                    <td class="text-start"><?php echo e($cliente->direccion); ?></td>
                    <td>
                        <a href="<?php echo e(route('clientes.edit', $cliente)); ?>" class="btn btn-warning btn-sm me-1">Editar</a>
                        <form action="<?php echo e(route('clientes.destroy', $cliente)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Deseas eliminar este cliente?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">Eliminar</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">No hay clientes registrados.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/clientes/index.blade.php ENDPATH**/ ?>