<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Reporte de Ventas</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
        }

        .logo {
            text-align: center;
            margin-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }

        .text-left {
            text-align: left;
        }
    </style>
</head>

<body>

    <div class="logo">
        <img src="<?php echo e(public_path('logoHeader.png')); ?>" alt="Logo" width="100">
    </div>

    <h2 style="text-align: center;">Reporte de Ventas</h2>

    <?php if(request('desde') || request('hasta')): ?>
    <p><strong>Filtro:</strong>
        <?php if(request('desde')): ?> Desde <?php echo e(request('desde')); ?> <?php endif; ?>
        <?php if(request('hasta')): ?> hasta <?php echo e(request('hasta')); ?> <?php endif; ?>
    </p>
    <?php endif; ?>

    <table>
        <thead>
            <tr>
                <th>Numero Venta</th>
                <th>Cliente</th>
                <th>Fecha</th>
                <th>Tipo</th>
                <th>Total Bs</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($venta->id); ?></td>
                <td class="text-left"><?php echo e($venta->cliente->nombre ?? 'Sin cliente'); ?></td>
                <td><?php echo e($venta->fecha_venta); ?></td>
                <td><?php echo e(ucfirst($venta->tipo_pago)); ?></td>
                <td><?php echo e(number_format($venta->total, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html><?php /**PATH C:\xampp\htdocs\ferr_limpio\resources\views/reportes/ventas/pdf.blade.php ENDPATH**/ ?>