

<?php $__env->startSection('title', 'Editar Venta'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 900px;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Editar Venta</h5>
            <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <form action="<?php echo e(route('ventas.update', $venta)); ?>" method="POST" id="ventaForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label for="tipo_documento" class="form-label">Tipo de Documento</label>
                <select name="tipo_documento" id="tipo_documento" class="form-select" required>
                    <option value="venta" <?php echo e($venta->tipo_documento == 'venta' ? 'selected' : ''); ?>>Venta</option>
                    <option value="cotizacion" <?php echo e($venta->tipo_documento == 'cotizacion' ? 'selected' : ''); ?>>Cotización</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="cliente_id" class="form-label">Cliente</label>
                <select name="cliente_id" id="cliente_id" class="form-select">
                    <option value="">Venta sin cliente</option>
                    <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cliente->id); ?>" <?php echo e($venta->cliente_id == $cliente->id ? 'selected' : ''); ?>>
                        <?php echo e($cliente->nombre); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="mb-3">
                <label for="estado_entrega" class="form-label">Estado de Entrega</label>
                <select name="estado_entrega" id="estado_entrega" class="form-select" required>
                    <option value="entregado" <?php echo e($venta->estado_entrega == 'entregado' ? 'selected' : ''); ?>>Entregado</option>
                    <option value="parcial" <?php echo e($venta->estado_entrega == 'parcial' ? 'selected' : ''); ?>>Parcial</option>
                    <option value="pendiente" <?php echo e($venta->estado_entrega == 'pendiente' ? 'selected' : ''); ?>>Pendiente</option>
                </select>
            </div>


            <div class="mb-3">
                <label for="fecha_venta" class="form-label">Fecha de Venta</label>
                <input type="date" name="fecha_venta" id="fecha_venta" class="form-control" value="<?php echo e($venta->fecha_venta); ?>">
            </div>

            <div class="mb-3">
                <label for="tipo_pago" class="form-label">Tipo de Pago</label>
                <select name="tipo_pago" id="tipo_pago" class="form-select" required>
                    <option value="contado" <?php echo e($venta->tipo_pago == 'contado' ? 'selected' : ''); ?>>Contado</option>
                    <option value="credito" <?php echo e($venta->tipo_pago == 'credito' ? 'selected' : ''); ?>>Crédito</option>
                </select>
            </div>

            <hr>
            <h6 class="mb-2">Productos (no editable por ahora)</h6>
            <ul class="list-group mb-3">
                <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <?php echo e($detalle->producto->nombre); ?> x <?php echo e($detalle->cantidad); ?>

                    <span>Bs. <?php echo e(number_format($detalle->subtotal, 2, ',', '.')); ?></span>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>

            <div class="mb-3">
                <label for="observaciones" class="form-label">Observaciones</label>
                <textarea name="observaciones" id="observaciones" class="form-control" rows="2"><?php echo e($venta->observaciones); ?></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Actualizar Venta</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/imagendig85b/public_html/isactamayo.imagendigitalb.com/resources/views/ventas/edit.blade.php ENDPATH**/ ?>