

<?php $__env->startSection('title', 'Detalle de Venta'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 400px;"> 

        <div class="text-center mb-2">
            <h5>🧾 Detalle de Venta N° <?php echo e($venta->id); ?></h5>
            <small>Ferretería Eloy Salmón</small>
        </div>

        <div>
            <strong>Cliente:</strong> <?php echo e($venta->cliente->nombre ?? 'Venta directa'); ?><br>
            <strong>Fecha:</strong> <?php echo e($venta->fecha_venta); ?><br>
            <strong>Pago:</strong> <?php echo e(ucfirst($venta->tipo_pago)); ?><br>
            <strong>Documento:</strong> <?php echo e(ucfirst($venta->tipo_documento)); ?><br>
            <strong>Observaciones:</strong> <?php echo e($venta->observaciones ?? 'Ninguna'); ?><br>
        </div>

        <hr>

        <table class="table table-sm table-bordered mb-2">
            <thead class="table-light text-center">
                <tr>
                    <th>Prod.</th>
                    <th>Cant</th>
                    <th>P/U</th>
                    <th>Subt</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-center">
                    <td class="text-start"><?php echo e($detalle->producto->nombre); ?></td>
                    <td><?php echo e($detalle->cantidad); ?></td>
                    <td><?php echo e(number_format($detalle->precio_unitario, 2)); ?></td>
                    <td><?php echo e(number_format($detalle->subtotal, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="text-end fw-bold">
            Total: Bs. <?php echo e(number_format($venta->total, 2, ',', '.')); ?>

        </div>

        <div class="d-flex justify-content-between mt-3">
            <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-sm btn-secondary">← Volver</a>
            <a href="<?php echo e(route('ventas.pdf', $venta->id)); ?>" class="btn btn-sm btn-danger" target="_blank">
                🖨️ Imprimir Ticket
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/ventas/show.blade.php ENDPATH**/ ?>