

<?php $__env->startSection('title', 'Nuevo Usuario'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 700px;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Registrar Nuevo Usuario</h5>
            <a href="<?php echo e(route('usuarios.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('usuarios.store')); ?>" method="POST" class="mt-3">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
                <label for="nombres" class="form-label">Nombres</label>
                <input type="text" name="nombres" id="nombres" class="form-control" value="<?php echo e(old('nombres')); ?>" required>
            </div>

            <div class="mb-3">
                <label for="apellido_paterno" class="form-label">Apellido Paterno</label>
                <input type="text" name="apellido_paterno" id="apellido_paterno" class="form-control" value="<?php echo e(old('apellido_paterno')); ?>">
            </div>

            <div class="mb-3">
                <label for="apellido_materno" class="form-label">Apellido Materno</label>
                <input type="text" name="apellido_materno" id="apellido_materno" class="form-control" value="<?php echo e(old('apellido_materno')); ?>">
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">Correo Electrónico</label>
                <input type="email" name="email" id="email" class="form-control" value="<?php echo e(old('email')); ?>" required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Contraseña</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="password_confirmation" class="form-label">Confirmar Contraseña</label>
                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="rol" class="form-label">Rol</label>
                <select name="rol" id="rol" class="form-select" required>
                    <option value="usuario" <?php echo e(old('rol') == 'usuario' ? 'selected' : ''); ?>>Usuario</option>
                    <option value="operador" <?php echo e(old('rol') == 'operador' ? 'selected' : ''); ?>>Operador</option>
                    <option value="administrador" <?php echo e(old('rol') == 'administrador' ? 'selected' : ''); ?>>Administrador</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="estado" class="form-label">Estado</label>
                <select name="estado" id="estado" class="form-select" required>
                    <option value="activo" <?php echo e(old('estado') == 'activo' ? 'selected' : ''); ?>>Activo</option>
                    <option value="inactivo" <?php echo e(old('estado') == 'inactivo' ? 'selected' : ''); ?>>Inactivo</option>
                </select>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Guardar Usuario</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/usuarios/create.blade.php ENDPATH**/ ?>