<!-- app.blade.php -->
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Sistema'); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('logoHeader.png')); ?>" type="image/x-icon">
    <!-- Bootstrap & Fonts -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

    <!-- Estilos globales -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: rgb(243, 218, 193);
        }

        .navbar-brand img {
            height: 60px;
        }

        .navbar {
            background-color: rgb(244, 160, 50);
        }

        main {
            margin-top: 70px;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <!-- ✅ Mostrar solo si el usuario está autenticado -->
    <?php if(auth()->guard()->check()): ?>
    <!-- ✅ Barra de navegación global -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top shadow" style="background-color: #f7951d;">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center" href="<?php echo e(route('dashboard')); ?>">
                <img src="<?php echo e(asset('logoHeader.png')); ?>" alt="Logo" class="me-2">
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-between" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('dashboard')); ?>">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('usuarios.*') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('usuarios.index')); ?>">Usuarios</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('categorias.*') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('categorias.index')); ?>">Categorías</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('productos.*') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('productos.index')); ?>">Productos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('clientes.*') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('clientes.index')); ?>">Clientes</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('ventas.*') ? 'active fw-semibold' : ''); ?>" href="<?php echo e(route('ventas.index')); ?>">Ventas</a>
                    </li>
                </ul>

                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-light btn-sm">Cerrar sesión</button>
                </form>
            </div>
        </div>
    </nav>
    <br><br><br><br>
    <?php endif; ?>


    <?php echo $__env->yieldContent('content'); ?>


    <!-- Scripts globales -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/layouts/app.blade.php ENDPATH**/ ?>