

<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>

<div class="login-box text-center">
    <img src="<?php echo e(asset('logominigolden.png')); ?>" class="img-fluid" style="max-height: 200px;"><br><br>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <?php echo e($errors->first()); ?>

    </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('login.post')); ?>">
        <?php echo csrf_field(); ?>

        <div class="form-floating mb-3">
            <input type="email" name="email" class="form-control" id="emailInput" placeholder="correo@empresa.com" required autofocus value="<?php echo e(old('email')); ?>">
            <label for="emailInput">Correo electrónico</label>
        </div>

        <div class="form-floating mb-4">
            <input type="password" name="password" class="form-control" id="passwordInput" placeholder="Contraseña" required>
            <label for="passwordInput">Contraseña</label>
        </div>

        <button type="submit" class="btn btn-primary w-100">Iniciar sesión</button>
        <button type="button" class="btn btn-outline-secondary w-100 mt-3" data-bs-toggle="modal" data-bs-target="#asistenciaModal">
            Marcar Asistencia
        </button>
        <button type="button" class="btn btn-outline-secondary w-100 mt-2" data-bs-toggle="modal" data-bs-target="#salidaModal">
            Marcar Salida
        </button>

    </form>
</div>
<!-- Modal de Marcaje de Asistencia -->
<div class="modal fade" id="asistenciaModal" tabindex="-1" aria-labelledby="asistenciaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('asistencia.entrada')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="asistenciaModalLabel">Marcar Asistencia</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="ci" class="form-label">Cédula de Identidad</label>
                        <input type="text" name="ci" id="ci" class="form-control" required>
                    </div>

                    <input type="hidden" name="ubicacion_marcaje" id="ubicacion_marcaje">
                    <p class="small text-muted">Tu ubicación se registrará automáticamente al marcar.</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Registrar Entrada</button>
                </div>


            </div>
        </form>
    </div>
</div>

<!-- Modal de Marcaje de Salida -->
<div class="modal fade" id="salidaModal" tabindex="-1" aria-labelledby="salidaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('asistencia.salida')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="salidaModalLabel">Marcar Salida</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="ci_salida" class="form-label">Cédula de Identidad</label>
                        <input type="text" name="ci" id="ci_salida" class="form-control" required>
                    </div>
                    <p class="small text-muted">Tu salida será registrada sin necesidad de iniciar sesión.</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Registrar Salida</button>
                </div>
            </div>
        </form>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .login-box {
        max-width: 400px;
        margin: auto;
        margin-top: 80px;
        padding: 30px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 0 25px rgba(0, 0, 0, 0.1);
    }

    .logo-img {
        max-height: 80px;
        margin-bottom: 20px;
    }
</style>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        navigator.geolocation.getCurrentPosition(function(position) {
            const lat = position.coords.latitude;
            const lon = position.coords.longitude;
            const url = `https://www.openstreetmap.org/?mlat=${lat}&mlon=${lon}`;
            document.getElementById('ubicacion_marcaje').value = url;
        }, function(error) {
            console.warn("No se pudo obtener la ubicación.");
        });
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/auth/login.blade.php ENDPATH**/ ?>