

<?php $__env->startSection('title', 'Nuevo Producto'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 700px;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Registrar Nuevo Producto</h5>
            <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('productos.store')); ?>" method="POST" class="mt-3">
            <?php echo csrf_field(); ?>
            
    <div class="mb-3">
        <label for="nombre" class="form-label">Nombre del Producto</label>
        <input type="text" name="nombre" id="nombre" class="form-control" value="<?php echo e(old('nombre')); ?>" required>
    </div>

    <div class="mb-3">
        <label for="categoria_id" class="form-label">Categoría</label>
        <select name="categoria_id" id="categoria_id" class="form-select" required>
            <option value="">Seleccione una categoría</option>
            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($categoria->id); ?>" <?php echo e(old('categoria_id') == $categoria->id ? 'selected' : ''); ?>>
                <?php echo e($categoria->nombre); ?>

            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="mb-3">
        <label for="descripcion" class="form-label">Descripción</label>
        <textarea name="descripcion" id="descripcion" class="form-control"><?php echo e(old('descripcion')); ?></textarea>
    </div>

    <div class="mb-3">
        <label for="marca" class="form-label">Marca</label>
        <input type="text" name="marca" id="marca" class="form-control" value="<?php echo e(old('marca')); ?>">
    </div>


    <div class="mb-3">
        <label for="unidad" class="form-label">Unidad</label>
        <input type="text" name="unidad" id="unidad" class="form-control" value="<?php echo e(old('unidad')); ?>" placeholder="Ej: unidad, metro, tonelada, caja..." required>
    </div>



    <div class="mb-3">
        <label for="stock" class="form-label">Stock</label>
        <input type="number" name="stock" id="stock" class="form-control" value="<?php echo e(old('stock', 0)); ?>" required>
    </div>

    <div class="mb-3">
        <label for="costo" class="form-label">Costo (Bs.)</label>
        <input type="number" step="0.01" name="costo" id="costo" class="form-control" value="<?php echo e(old('costo')); ?>" required>
    </div>


    <div class="mb-4">
        <label for="precio" class="form-label">Precio (Bs.)</label>
        <input type="number" step="0.01" name="precio" id="precio" class="form-control" value="<?php echo e(old('precio')); ?>" required>
    </div>

    <div class="text-end">
        <button type="submit" class="btn btn-primary">Guardar Producto</button>
    </div>
    </form>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sistema-ferreteria\resources\views/productos/create.blade.php ENDPATH**/ ?>