

<?php $__env->startSection('title', 'Registrar Venta'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-center">
    <div class="card shadow p-4" style="width: 100%; max-width: 900px;">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Registrar Nueva Venta</h5>
            <a href="<?php echo e(route('ventas.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <div id="productosData" data-productos='<?php echo json_encode($productos, 15, 512) ?>'></div>



        <form action="<?php echo e(route('ventas.store')); ?>" method="POST" id="ventaForm">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
                <label for="tipo_documento" class="form-label">Tipo de Documento</label>
                <select name="tipo_documento" id="tipo_documento" class="form-select" required>
                    <option value="venta">Venta</option>
                    <option value="cotizacion">Cotización</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="estado_entrega" class="form-label">Estado de Entrega</label>
                <select name="estado_entrega" id="estado_entrega" class="form-select" required>
                    <option value="entregado">Entregado</option>
                    <option value="parcial">Parcial</option>
                    <option value="pendiente">Pendiente</option>
                </select>
            </div>



            <div class="mb-3">
                <label for="cliente_id" class="form-label">Cliente</label>
                <select name="cliente_id" id="cliente_id" class="form-select">
                    <option value="">Venta sin cliente</option>
                    <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cliente->id); ?>"><?php echo e($cliente->nombre); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="mb-3">
                <label for="fecha_venta" class="form-label">Fecha de Venta</label>
                <input type="date" name="fecha_venta" id="fecha_venta" class="form-control" value="<?php echo e(now()->toDateString()); ?>" readonly>
            </div>

            <div class="mb-3">
                <label for="tipo_pago" class="form-label">Tipo de Pago</label>
                <select name="tipo_pago" id="tipo_pago" class="form-select" required>
                    <option value="">Seleccione una opción</option>
                    <option value="contado">Contado</option>
                    <option value="credito">Crédito</option>
                </select>
            </div>

            <hr>

            <h6>Productos</h6>
            <div id="productosContainer"></div>
            <button type="button" class="btn btn-sm btn-secondary my-2" onclick="agregarProducto()">+ Agregar Producto</button>

            <hr>

            <div class="mb-3">
                <label class="form-label">Total: Bs.</label>
                <input type="text" id="total" name="total_visible" class="form-control" readonly>
            </div>

            <input type="hidden" name="productos_json" id="productos_json">

            <div class="mb-3">
                <label for="observaciones" class="form-label">Observaciones</label>
                <textarea name="observaciones" id="observaciones" class="form-control" rows="2"></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Guardar Venta</button>
            </div>
        </form>
    </div>
</div>

<script>
    let productos = JSON.parse(document.getElementById('productosData').dataset.productos);
    let productosAgregados = [];

    function agregarProducto() {
        const index = productosAgregados.length;
        const container = document.getElementById('productosContainer');

        const row = document.createElement('div');
        row.className = 'row mb-2 align-items-end';
        row.innerHTML = `
            <div class="col-md-6">
                <label class="form-label">Producto</label>
                <input type="text" class="form-control" placeholder="Buscar producto..." id="producto_nombre_${index}" oninput="buscarProducto(this, ${index})" autocomplete="off">
                    <input type="hidden" id="producto_${index}">
                    <div class="list-group position-absolute w-100" id="sugerencias_${index}" style="z-index: 10;"></div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Cantidad</label>
                <input type="number" class="form-control" min="1" value="1" onchange="actualizarTotal()" id="cantidad_${index}">
            </div>
            <div class="col-md-3">
                <label class="form-label">Subtotal</label>
                <input type="text" class="form-control" readonly id="subtotal_${index}">
            </div>
            <div class="col-md-1 text-end">
                <button type="button" class="btn btn-sm btn-danger" onclick="eliminarProducto(this)">✕</button>
            </div>
        `;

        container.appendChild(row);
        productosAgregados.push(index);
        actualizarPrecio(index);
    }

    function actualizarPrecio(index) {
        const select = document.getElementById(`producto_${index}`);
        const precio = parseFloat(select?.dataset?.precio || 0);
        const cantidad = parseInt(document.getElementById(`cantidad_${index}`).value || 0);
        const subtotal = precio * cantidad;

        document.getElementById(`subtotal_${index}`).value = subtotal.toFixed(2);
        actualizarTotal();
    }

    function actualizarTotal() {
        let total = 0;

        productosAgregados.forEach(index => {
            const inputHidden = document.getElementById(`producto_${index}`);
            const cantidad = parseInt(document.getElementById(`cantidad_${index}`).value || 0);
            const precio = parseFloat(inputHidden?.dataset?.precio || 0);

            const subtotal = precio * cantidad;
            document.getElementById(`subtotal_${index}`).value = subtotal.toFixed(2);
            total += subtotal;
        });

        document.getElementById('total').value = total.toFixed(2);
        actualizarJson();
    }

    function eliminarProducto(btn) {
        btn.closest('.row').remove();
        actualizarTotal();
    }

    function actualizarJson() {
        const productosFinal = productosAgregados.map(index => {
            const productoId = document.getElementById(`producto_${index}`)?.value;
            const cantidad = document.getElementById(`cantidad_${index}`)?.value;
            return {
                id: productoId,
                cantidad: cantidad
            };
        }).filter(p => p.id && p.id !== '');

        document.getElementById('productos_json').value = JSON.stringify(productosFinal);
    }

    document.getElementById('ventaForm').addEventListener('submit', function(e) {
        actualizarJson(); // actualiza el campo oculto
    });

    function buscarProducto(input, index) {
        const termino = input.value.toLowerCase();
        const sugerencias = document.getElementById(`sugerencias_${index}`);
        sugerencias.innerHTML = '';

        if (termino.length < 2) return;

        const coincidencias = productos.filter(p => p.nombre.toLowerCase().includes(termino));

        coincidencias.forEach(producto => {
            const item = document.createElement('button');
            item.type = 'button';
            item.className = 'list-group-item list-group-item-action';
            item.textContent = `${producto.nombre} (Stock: ${producto.stock})`;
            item.onclick = () => seleccionarProducto(producto, index);
            sugerencias.appendChild(item);
        });
    }

    function seleccionarProducto(producto, index) {
        document.getElementById(`producto_nombre_${index}`).value = producto.nombre;
        document.getElementById(`producto_${index}`).value = producto.id;

        // Guardar temporalmente precio y stock en data-attributes
        document.getElementById(`producto_${index}`).dataset.precio = producto.precio;
        document.getElementById(`producto_${index}`).dataset.stock = producto.stock;

        document.getElementById(`sugerencias_${index}`).innerHTML = '';
        actualizarPrecio(index);
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/imagendig85b/public_html/isactamayo.imagendigitalb.com/resources/views/ventas/create.blade.php ENDPATH**/ ?>