

<?php $__env->startSection('title', 'Productos'); ?>

<?php $__env->startSection('content'); ?>
<div class="container d-flex justify-content-between align-items-center mb-4" style="max-width: 900px;">
    <h4 class="mb-0">Lista de productos</h4>
    <a href="<?php echo e(route('productos.create')); ?>" class="btn btn-primary">+ Nuevo Producto</a>
</div>


<div class="container mb-3" style="max-width: 900px;">
    <form method="GET" action="<?php echo e(route('productos.index')); ?>" class="d-flex">
        <input type="text" name="buscar" class="form-control me-2" placeholder="Buscar por nombre o código..." value="<?php echo e(request('buscar')); ?>">
        <button type="submit" class="btn btn-secondary">Buscar</button>
    </form>
</div>


<?php if(session('success')): ?>
<div class="container" style="max-width: 900px;">
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
</div>
<?php endif; ?>

<div class="container" style="max-width: 900px;">
    <div class="table-responsive rounded shadow-sm bg-white">
        <table class="table table-bordered table-hover align-middle mb-0">
            <thead class="table-light">
                <tr class="text-center">
                    <th style="width: 60px;">Nro.</th>
                    <th>Código</th>
                    <th>Nombre</th>
                    <th>Categoría</th>
                    <th>Costo</th>
                    <th>Precio</th>
                    <th>Marca</th>
                    <th>Unidad</th>
                    <th>Stock</th>
                    <th>Imagen</th>
                    <th style="width: 180px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="text-center">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($producto->codigo); ?></td>
                    <td class="text-start"><?php echo e($producto->nombre); ?></td>
                    <td class="text-start"><?php echo e($producto->categoria->nombre ?? '-'); ?></td>
                    <td>Bs. <?php echo e(number_format($producto->costo, 2, ',', '.')); ?></td>
                    <td>Bs. <?php echo e(number_format($producto->precio, 2, ',', '.')); ?></td>
                    <td><?php echo e($producto->marca ?? '-'); ?></td>
                    <td><?php echo e($producto->unidad); ?></td>
                    <td><?php echo e($producto->stock); ?></td>
                    <td class="text-center">
                        <?php if($producto->imagen): ?>
                        <img src="<?php echo e(route('productos.imagen', $producto->imagen)); ?>" alt="Imagen" width="50">
                        <?php else: ?>
                        <small>Sin imagen</small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('productos.edit', $producto)); ?>" class="btn btn-warning btn-sm me-1">Editar</a>
                        <form action="<?php echo e(route('productos.destroy', $producto)); ?>" method="POST" class="d-inline" onsubmit="return confirm('¿Deseas eliminar este producto?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">Eliminar</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">No hay productos registrados.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/imagendig85b/public_html/isactamayo.imagendigitalb.com/resources/views/productos/index.blade.php ENDPATH**/ ?>