<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 5px;
            width: 100%;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }

        .totales {
            margin-top: 10px;
        }

        hr {
            border: none;
            border-top: 1px dashed #000;
        }
    </style>

</head>

<body>

    <div class="text-center">
        <strong>Ferretería Isac Tamayo</strong><br>
        <strong>Bueno Bonito Barato</strong><br>
        <hr>
    </div>

    <strong>Venta N°:</strong> <?php echo e($venta->id); ?><br>
    <strong>Fecha:</strong> <?php echo e($venta->fecha_venta); ?><br>
    <strong>Cliente:</strong> <?php echo e($venta->cliente->nombre ?? 'Venta directa'); ?><br>
    <strong>Pago:</strong> <?php echo e(ucfirst($venta->tipo_pago)); ?><br>
    <strong>Documento:</strong> <?php echo e(ucfirst($venta->tipo_documento)); ?><br>

    <hr>

    <table>
        <thead>
            <tr>
                <th>Prod.</th>
                <th class="text-right">Cant</th>
                <th class="text-right">P/U</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($detalle->producto->nombre); ?></td>
                <td class="text-right"><?php echo e($detalle->cantidad); ?></td>
                <td class="text-right"><?php echo e(number_format($detalle->precio_unitario, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($detalle->subtotal, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <hr>

    <table class="totales">
        <tr>
            <td>Total:</td>
            <td class="text-right">Bs. <?php echo e(number_format($venta->total, 2)); ?></td>
        </tr>
    </table>

    <div class="text-center" style="margin-top: 10px;">
        <small>Gracias por su compra</small>
    </div>

</body>

</html><?php /**PATH /home/imagendig85b/public_html/isactamayo.imagendigitalb.com/resources/views/ventas/pdf.blade.php ENDPATH**/ ?>